﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace PalmSens
{
    public class StreamDevice : IDisposable
    {
        private Stream _deviceStream;
        private StreamWriter _deviceWriter;
        private StreamReader _deviceReader;
        private int _timeoutMS;

        internal StreamDevice(Stream deviceStream, int timeoutMS = 5000)
        {
            _deviceStream = deviceStream;
            deviceStream.ReadTimeout = timeoutMS;
            _timeoutMS = timeoutMS;
            //ASCII encoding as this is embedded communication not exposed to the user
            _deviceWriter = new StreamWriter(deviceStream, Encoding.ASCII, 4096, true);
            _deviceWriter.AutoFlush = true;
            _deviceReader = new StreamReader(deviceStream, Encoding.ASCII, false, 4096, true);
        }

        public static string ToHex(byte[] data, int startIndex, int length)
        {
            StringBuilder str = new StringBuilder(length * 2);
            for (int i = startIndex; i < startIndex + length; i++)
                str.Append(data[i].ToString("X2"));
            return str.ToString();
        }

        /// <summary>
        /// Send cmd and awaits response of cmd.
        /// </summary>
        public string SendCmd(string cmd)
        {
            _deviceWriter.Write(cmd + "\n"); //version cmd
            if(cmd.Length > 0)
                WaitForString(cmd[0].ToString());

            return WaitForString("\n");
        }

        /// <summary>
        /// Waits for char.
        /// </summary>
        public string WaitForString(string waitStr)
        {
            DateTime endTime = DateTime.Now + TimeSpan.FromMilliseconds(_timeoutMS);
            string str = "";
            do
            {
                int c = _deviceReader.Read();
                if (c > 0)
                {
                    str += (char)c;
                    if (str.EndsWith(waitStr))
                        return str;
                }
            }
            while (DateTime.Now < endTime);

            return null;
        }

        public void Dispose()
        {
            _deviceWriter?.Dispose();
            _deviceReader?.Dispose();
            _deviceStream?.Dispose();

            _deviceWriter = null;
            _deviceReader = null;
            _deviceStream = null;
        }
    }
}
